<?php
/**
 * Get whether captcha page is enabled
 * @return bool
 */
function isCaptchaEnabled() {
    $file = __DIR__ . '/captcha_setting.json';
    if (!file_exists($file)) {
        return true;
    }
    $data = @json_decode(@file_get_contents($file), true);
    return isset($data['enabled']) ? (bool)$data['enabled'] : true;
}

/**
 * Set captcha enabled/disabled
 * @param bool $enabled
 * @return bool success
 */
function setCaptchaEnabled($enabled) {
    $file = __DIR__ . '/captcha_setting.json';
    return @file_put_contents($file, json_encode(['enabled' => (bool)$enabled])) !== false;
}
